
// PluralDlg.cpp : t@C
//

#include "stdafx.h"
#include "Plural.h"
#include "PluralDlg.h"
#include "afxdialogex.h"
#include "CMadoriApp.h"
#include "CMadoriDoc.h"
#include <tlhelp32.h>
#include <locale.h>
#include <psapi.h>
#include <Winternl.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

typedef NTSTATUS (WINAPI *_NtQueryInformationProcess)(
  __in	   HANDLE ProcessHandle,
  __in	   PROCESSINFOCLASS ProcessInformationClass,
  __out	  PVOID ProcessInformation,
  __in	   ULONG ProcessInformationLength,
  __out_opt  PULONG ReturnLength);
_NtQueryInformationProcess NtQip = NULL;


// CPluralDlg _CAO



CPluralDlg::CPluralDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CPluralDlg::IDD, pParent)
	, m_strROT(_T(""))
	, m_strName(_T(""))
	, m_strWnds(_T(""))
	, m_hWnd(0)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	setlocale( LC_ALL, "japanese" );
	if(!NtQip) NtQip = (_NtQueryInformationProcess)GetProcAddress(GetModuleHandle(_T("ntdll.dll")), "NtQueryInformationProcess"); 
}

void CPluralDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT1, m_strROT);
	DDX_Text(pDX, IDC_EDIT2, m_strName);
	DDX_Text(pDX, IDC_EDIT3, m_strWnds);
	DDX_Text(pDX, IDC_EDIT4, m_hWnd);
}

BEGIN_MESSAGE_MAP(CPluralDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, &CPluralDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CPluralDlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CPluralDlg::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON4, &CPluralDlg::OnBnClickedButton4)
	ON_BN_CLICKED(IDC_BUTTON5, &CPluralDlg::OnBnClickedButton5)
END_MESSAGE_MAP()


// CPluralDlg bZ[W nh[

BOOL CPluralDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// ̃_CAÕACRݒ肵܂BAvP[ṼC EBhE_CAOłȂꍇA
	//  Framework ́A̐ݒIɍs܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

	// TODO: ɒǉ܂B

	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CPluralDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// [U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CPluralDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


// Running Object Table 
void CPluralDlg::OnBnClickedButton1()
{
	m_strROT.Empty();
    IBindCtx *pbc;
    HRESULT hr = CreateBindCtx(0, &pbc);
    if(FAILED(hr)) {
        TRACE(_T("CreateBindCtx error %d\n"), hr);
        return;
    }

    IRunningObjectTable *prot;
    hr = pbc->GetRunningObjectTable(&prot);
    if(FAILED(hr)) {
        TRACE(_T("GetRunningObjectTable error %d\n"), hr);
        pbc->Release();
        return;
    }

    IEnumMoniker *pem;
    hr = prot->EnumRunning(&pem);
    if(FAILED(hr)) {
        TRACE(_T("EnumRunning error %d\n"), hr);
        prot->Release();
        pbc->Release();
        return;
    }
    pem->Reset();

    ULONG fetched;
    IMoniker *pmon;
    int n = 0;
    while(pem->Next(1, &pmon, &fetched) == S_OK) {

        // Get DisplayName.
        LPOLESTR pName;
        pmon->GetDisplayName(pbc, NULL, &pName);
		TRACE(_T("%s\n"), pName);
		m_strROT += pName;
		m_strROT += _T("\r\n");

        // Release interfaces.
        pmon->Release();

    }

    // Release interfaces.
    pem->Release();
    prot->Release();
    pbc->Release();

	UpdateData(FALSE);

}

const wchar_t * idDoc = L"MyHomeDesignerMadori.MadoriDoc";
const wchar_t * idApp = L"MyHomeDesignerMadori.MadoriApp";
// Attach
void CPluralDlg::OnBnClickedButton2()
{
	UpdateData();
	Attach(m_strName);
}

void CPluralDlg::Attach(CString & strName){
	LPUNKNOWN pUnk = NULL;
	LPDISPATCH pDisp = NULL;
	CLSID clsid;

	if(strName.Find(idDoc) >= 0){
		CMadoriDoc * pMadoriDoc = new CMadoriDoc();
		// CLSID擾
		if (S_OK != CLSIDFromProgID (idDoc, &clsid))
		{
			AfxMessageBox (_T("MadoriDoc o^łB\n[vOCXg[]\\Wizard\\madori\\Program\\madori.exe AǗҌŎsĂB"));
			return;
		}
		IDispatch * pDisp = GetDispatch(strName);
		if(pDisp){
			pMadoriDoc->AttachDispatch (pDisp);
			CString str;
			long pid = pMadoriDoc->GetProcessId();
			long hwd = pMadoriDoc->GetHwnd();
			str.Format(_T("pid[%d]hwd[%x]"), pid, hwd);
			AfxMessageBox((LPCTSTR)str);
			pMadoriDoc->ReleaseDispatch();
			delete pMadoriDoc;
		}else{
			TRACE(_T("Attach error 1\n"));
		}
	}else if(strName.Find(idApp) >= 0){
		CMadoriApp * pMadoriApp = new CMadoriApp();
		// CLSID擾
		if (S_OK != CLSIDFromProgID (idApp, &clsid))
		{
			AfxMessageBox (_T("MadoriApp o^łB\n[vOCXg[]\\Wizard\\madori\\Program\\madori.exe AǗҌŎsĂB"));
			return;
		}
		IDispatch * pDisp = GetDispatch(strName);
		if(pDisp){
			pMadoriApp->AttachDispatch (pDisp);
			CString str;
			long pid = pMadoriApp->GetProcessId();
			long hwd = pMadoriApp->GetHwnd();
			str.Format(_T("pid[%d]hwd[%x]"), pid, hwd);
			AfxMessageBox((LPCTSTR)str);
			pMadoriApp->ReleaseDispatch();
			delete pMadoriApp;
		}else{
			TRACE(_T("Attach error 2\n"));
		}
	}else{
		TRACE(_T("Attach error 9\n"));
	}
}

IDispatch* CPluralDlg::GetDispatch(CString & strName)
{
    IBindCtx *pbc;
    HRESULT hr = CreateBindCtx(0, &pbc);
    if(FAILED(hr)) {
        TRACE(_T("CreateBindCtx error %d\n"), hr);
        return NULL;
    }

    IRunningObjectTable *prot;
    hr = pbc->GetRunningObjectTable(&prot);
    if(FAILED(hr)) {
        TRACE(_T("GetRunningObjectTable error %d\n"), hr);
        pbc->Release();
        return NULL;
    }

    IEnumMoniker *pem;
    hr = prot->EnumRunning(&pem);
    if(FAILED(hr)) {
        TRACE(_T("EnumRunning error %d\n"), hr);
        prot->Release();
        pbc->Release();
        return NULL;
    }

    pem->Reset();

    // Churn through enumeration.
    ULONG fetched;
    IMoniker *pmon;
	IDispatch *pDisp = NULL;
    int n = 0;
    while(pem->Next(1, &pmon, &fetched) == S_OK) {

        LPOLESTR pName;
        pmon->GetDisplayName(pbc, NULL, &pName);
		TRACE(_T("%s\n"), pName);

		if(!_tcscmp(pName, strName))
		{
			// Bind to this ROT entry.
			IUnknown *pUnknown;
			hr = prot->GetObject(pmon, &pUnknown);
			if(!FAILED(hr)) {
				TRACE(_T("ok\n"));
				pUnknown->QueryInterface (IID_IDispatch, (void**)(&pDisp));
			}else{
				TRACE(_T("error\n"));
			}

		}

        // Release interfaces.
        pmon->Release();

        // Break out if we obtained the IDispatch successfully.
        if(pDisp != NULL) break;
    }

    // Release interfaces.
    pem->Release();
    prot->Release();
    pbc->Release();
	return pDisp;
}


HWND hMadoriWindow = NULL;


BOOL CALLBACK EnumWindowsProcMadori(HWND hWnd, LPARAM lParam)
{
	static TCHAR *szTitle1 = _T(" - 3D}Cz[fUCi[PRO8");

	DWORD dwProcessId = 0;
    ::GetWindowThreadProcessId(hWnd, &dwProcessId);
	if(lParam != dwProcessId) return TRUE;

	TCHAR	szTitle[256];
	GetWindowText(hWnd, szTitle, 250);
	szTitle[250] = 0;
	if (_tcsstr(szTitle, szTitle1) == 0)
		return TRUE;

	hMadoriWindow = hWnd;
	return FALSE;
}


HWND GetMadoriWindow(DWORD dwProcessIdMadori)
{
	hMadoriWindow = NULL;
	::EnumWindows((WNDENUMPROC)::EnumWindowsProcMadori, (LPARAM)dwProcessIdMadori);

	return hMadoriWindow;
}

// j[NꂽexeT
DWORD GetMadoriProcess(DWORD dwProcessIdMenu, CString & strCoop, LPCTSTR szExeName)
{
	DWORD dwRet = 0;
	strCoop.Empty();
	// vZX̃XibvVbg쐬܂B
	HANDLE hSnapshot = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS,0);
	PROCESSENTRY32 pe32;
	CString strMsg;
	pe32.dwSize = sizeof( PROCESSENTRY32 );
	if ( Process32First(hSnapshot,&pe32) )
	{
		do {
			if(dwProcessIdMenu != pe32.th32ParentProcessID) continue;

			TRACE(_T("vZXID[%x]ftHgq[vID[%x]W[ID[%x]XbhJEg[%d]evZXID[%x]{D惌x[%x]"),
				pe32.th32ProcessID, pe32.th32DefaultHeapID, pe32.th32ModuleID, pe32.cntThreads, pe32.th32ParentProcessID, pe32.pcPriClassBase);
			TRACE(_T("t@C[%s]\n"), pe32.szExeFile);

			if(szExeName && _tcsicmp(pe32.szExeFile, szExeName)) continue;

			HANDLE hProcess = OpenProcess(PROCESS_QUERY_INFORMATION | PROCESS_VM_READ,
				FALSE,pe32.th32ProcessID);
			if (!hProcess) continue;	// Ȃ񂩃G[

			dwRet = pe32.th32ProcessID;

			DWORD dwSize;
			HMODULE hMod[32];
			if (EnumProcessModules(hProcess, hMod, 32, &dwSize) ){
				MODULEINFO mi;
				GetModuleInformation(hProcess, hMod[0], &mi, sizeof(mi));

				TCHAR szProcessName[_MAX_PATH * 2];
				GetModuleFileNameEx( hProcess, hMod[0], szProcessName, sizeof(szProcessName));
				TRACE(_T("GetModuleFileNameEx[%s]\n"), szProcessName);	// tpX
				
				//PebBaseAddress̎擾
				PROCESS_BASIC_INFORMATION pb;
				ULONG ulSize;
				NTSTATUS stat = NtQip( hProcess, ProcessBasicInformation, &pb, sizeof(pb), &ulSize);
				BYTE * peb = (BYTE * )pb.PebBaseAddress;
				DWORD dw, read; 
				ReadProcessMemory(hProcess,peb + 0x10, &dw, sizeof(DWORD), &read);
				//CommandLinef[^JnAhX̎擾
				ReadProcessMemory(hProcess, (PVOID)(dw+0x44), &dw, sizeof(DWORD), &read);
				wchar_t params[0x200];
				ReadProcessMemory(hProcess, (PVOID)dw, &params, sizeof(params), &read); 
				TRACE(_T("CommandLine:%s\n"), params);

				TCHAR * pFind = _tcsstr(params, _T("/COOP:"));
				if(pFind){
					pFind += 6;
					TCHAR * pFind2 = _tcsstr(pFind, _T(" ")); 
					if(pFind2) *pFind2 = 0x00;
					strCoop = pFind;
					strCoop.Trim();
				}
			}
			CloseHandle(hProcess);
			if(strCoop.GetLength() > 0) break;
		} while ( Process32Next(hSnapshot,&pe32) );

		CloseHandle( hSnapshot );
	}
	return dwRet;

}

// CreateProcess ĂAAttach
void CPluralDlg::OnBnClickedButton3()
{

	// CXg[擾
	HKEY	hKey, hSubKey;
	CString strApp;
	if (ERROR_SUCCESS == RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\Megasoft\\3D MyHome Designer PRO 8"), 0, KEY_QUERY_VALUE, &hKey))
	{

		// fBNg
		if (ERROR_SUCCESS == RegOpenKeyEx(hKey, _T("Directories"), 0, KEY_QUERY_VALUE, &hSubKey))
		{
			DWORD dwType = REG_SZ;
			DWORD cbData[1];
			cbData[0] = MAX_PATH;
			TCHAR szTmp[MAX_PATH];
			if (ERROR_SUCCESS == RegQueryValueEx(hSubKey, _T("InstallDir"), NULL, &dwType, (LPBYTE)szTmp, cbData))
			{
				strApp = szTmp;	// ex.) "C:\Program Files\3DMHPRO8"
				strApp += _T("\\program\\3dmenupro8.exe");
			}
			RegCloseKey(hSubKey);
		}
		RegCloseKey(hKey);
	}
	if(strApp.GetLength() == 0){
		AfxMessageBox(_T("CXg[Ă܂"));
		return;
	}

	// N
	STARTUPINFO			si;
	PROCESS_INFORMATION	pi;
	ZeroMemory(&si, sizeof(STARTUPINFO));
	si.cb = sizeof(STARTUPINFO);
	si.dwFlags=STARTF_USESHOWWINDOW;
    si.wShowWindow = SW_SHOWNORMAL;

	int ret = CreateProcess(NULL, (LPTSTR)(LPCTSTR)strApp, NULL, NULL,
		FALSE, NORMAL_PRIORITY_CLASS, NULL, NULL, &si, &pi);
	if (ret)
	{
		// N

		// ɂ̓EChEłȂ̂ŁA܂
		ret = WaitForInputIdle(pi.hProcess,100000);

		// Ԏ̃vZX҂
		CString strCoop;
		DWORD dwProcessIdMadori = 0;
		for(int i = 0; i < 10; ++i){
			dwProcessIdMadori = GetMadoriProcess(pi.dwProcessId, strCoop, _T("madori.exe"));
			if(dwProcessIdMadori) break;
			Sleep(3000);
		}

		if(!dwProcessIdMadori) return;	// ȂԎ肪NĂȂ

		// Ԏ̃EBhE҂
		for(int i = 0; i < 10; ++i){
			if(GetMadoriWindow(dwProcessIdMadori)){
				TRACE(_T("Ԏ EBhE\n"));
				break;
			}
			TRACE(_T("gC\n"));
			Sleep(3000);
		}

		CString strTmp;
		strTmp.Format(_T("!MyHomeDesignerMadori.MadoriDoc:%s"), strCoop);
		Attach(strTmp);
	}
}

BOOL CALLBACK EnumWindowsProcAll(HWND hWnd, LPARAM lParam)
{

	TCHAR	szTitle[256];
	GetWindowText(hWnd, szTitle, 250);
	szTitle[250] = 0;

	CString * pStr = (CString *)lParam;
	CString strTmp;
	strTmp.Format(_T("hWnd[%d]title[%s]\r\n"), hWnd, szTitle);
	*pStr += strTmp;
	return TRUE;
}

// EChEnh
void CPluralDlg::OnBnClickedButton4()
{
	m_strWnds.Empty();
	::EnumWindows((WNDENUMPROC)::EnumWindowsProcAll, (LPARAM)&m_strWnds);

	UpdateData(FALSE);
}

// w肵vZXIDexeT
DWORD GetProcess(DWORD dwProcessId, CString & strCoop)
{

	DWORD dwRet = 0;
	strCoop.Empty();
	// vZX̃XibvVbg쐬܂B
	HANDLE hSnapshot = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS,0);
	PROCESSENTRY32 pe32;
	CString strMsg;
	pe32.dwSize = sizeof( PROCESSENTRY32 );
	if ( Process32First(hSnapshot,&pe32) )
	{
		do {
			if(dwProcessId != pe32.th32ProcessID) continue;

			TRACE(_T("vZXID[%x]ftHgq[vID[%x]W[ID[%x]XbhJEg[%d]evZXID[%x]{D惌x[%x]"),
				pe32.th32ProcessID, pe32.th32DefaultHeapID, pe32.th32ModuleID, pe32.cntThreads, pe32.th32ParentProcessID, pe32.pcPriClassBase);
			TRACE(_T("t@C[%s]\n"), pe32.szExeFile);

			HANDLE hProcess = OpenProcess(PROCESS_QUERY_INFORMATION | PROCESS_VM_READ,
				FALSE,pe32.th32ProcessID);
			if (!hProcess) continue;	// Ȃ񂩃G[

			dwRet = pe32.th32ProcessID;

			DWORD dwSize;
			HMODULE hMod[32];
			if (EnumProcessModules(hProcess, hMod, 32, &dwSize) ){
				MODULEINFO mi;
				GetModuleInformation(hProcess, hMod[0], &mi, sizeof(mi));

				TCHAR szProcessName[_MAX_PATH * 2];
				GetModuleFileNameEx( hProcess, hMod[0], szProcessName, sizeof(szProcessName));
				TRACE(_T("GetModuleFileNameEx[%s]\n"), szProcessName);	// tpX
				
				//PebBaseAddress̎擾
				PROCESS_BASIC_INFORMATION pb;
				ULONG ulSize;
				NTSTATUS stat = NtQip( hProcess, ProcessBasicInformation, &pb, sizeof(pb), &ulSize);
				BYTE * peb = (BYTE * )pb.PebBaseAddress;
				DWORD dw, read; 
				ReadProcessMemory(hProcess,peb + 0x10, &dw, sizeof(DWORD), &read);
				//CommandLinef[^JnAhX̎擾
				ReadProcessMemory(hProcess, (PVOID)(dw+0x44), &dw, sizeof(DWORD), &read);
				wchar_t params[0x200];
				ReadProcessMemory(hProcess, (PVOID)dw, &params, sizeof(params), &read); 
				TRACE(_T("CommandLine:%s\n"), params);

				TCHAR * pFind = _tcsstr(params, _T("/COOP:"));
				if(pFind){
					pFind += 6;
					TCHAR * pFind2 = _tcsstr(pFind, _T(" ")); 
					if(pFind2) *pFind2 = 0x00;
					strCoop = pFind;
					strCoop.Trim();
				}
			}
			CloseHandle(hProcess);
			if(strCoop.GetLength() > 0) break;
		} while ( Process32Next(hSnapshot,&pe32) );

		CloseHandle( hSnapshot );
	}
	return dwRet;

}

// EChEnhAR}hCāAAttach
void CPluralDlg::OnBnClickedButton5()
{
	UpdateData();
	DWORD dwProcessId = 0;
    ::GetWindowThreadProcessId((HWND)m_hWnd, &dwProcessId);
	
	CString strCoop;
	if(!GetProcess(dwProcessId, strCoop) || strCoop.GetLength() == 0){
		AfxMessageBox(_T("Ώ̂exeł͂܂"));
	}else{
		CString strTmp;
		strTmp.Format(_T("!MyHomeDesignerMadori.MadoriDoc:%s"), strCoop);
		Attach(strTmp);
	}
}
